#include <cstdio>
#include <algorithm>
#include <utility>

using namespace std;

bool intersect(int x1, int y1, int x2, int y2,
               int x3, int y3, int x4, int y4) {
  if (x2 <= x3) return false;
  if (x4 <= x1) return false;
  if (y2 <= y3) return false;
  if (y4 <= y1) return false;
  return true;
}

long long calc(pair<int, int> b[], int k1, int k2, int k3, int k4) {
  int x1 = 0;
  int y1 = 0;
  int x2 = b[0].first;
  int y2 = b[0].second;

  auto where = [&](int rx1, int rx2, int ry1, int ry2, int k) -> pair<int, int> {
    if (k == 0) return {rx1, ry1};
    if (k == 1) return {rx1, ry2};
    if (k == 2) return {rx2, ry1};
    return {rx2, ry2};
  };

  int x3 = where(x1, x2, y1, y2, k1).first -
    where(0, 0, b[1].first, b[1].second, k2).first;
  int y3 = where(x1, x2, y1, y2, k1).second -
    where(0, 0, b[1].first, b[1].second, k2).second;
  int x4 = x3 + b[1].first;
  int y4 = y3 + b[1].second;

  int x5, x6, y5, y6;
  if (k3 >= 4) {
    k3 -= 4;
    x5 = where(x1, x2, y1, y2, k3).first -
      where(0, 0, b[2].first, b[2].second, k4).first;
    y5 = where(x1, x2, y1, y2, k3).second -
      where(0, 0, b[2].first, b[2].second, k4).second;
    x6 = x5 + b[2].first;
    y6 = y5 + b[2].second;
  }
  x5 = where(x3, x4, y3, y4, k3).first -
    where(0, 0, b[2].first, b[2].second, k4).first;
  y5 = where(x3, x4, y3, y4, k3).second -
    where(0, 0, b[2].first, b[2].second, k4).second;
  x6 = x5 + b[2].first;
  y6 = y5 + b[2].second;

  if (intersect(x1, y1, x2, y2, x3, y3, x4, y4)) return -1;
  if (intersect(x1, y1, x2, y2, x5, y5, x6, y6)) return -1;
  if (intersect(x3, y3, x4, y4, x5, y5, x6, y6)) return -1;
  int maxx = max(max(x2, x4), x6);
  int minx = min(min(x1, x3), x5);
  int maxy = max(max(y2, y4), y6);
  int miny = min(min(y1, y3), y5);
  return (long long)(maxx - minx) * (maxy - miny);
}

int main() {
  pair<int, int> a[3];
  for (int i = 0; i < 3; ++i) {
    scanf("%d%d", &a[i].first, &a[i].second);
  }

  int o[] = {0, 1, 2};
  long long ans = 1e18;
  do {
    pair<int, int> b[] = {a[o[0]], a[o[1]], a[o[2]]};
    for (int i = 0; i < 2; ++i) {
      swap(b[1].first, b[1].second);
      for (int j = 0; j < 2; ++j) {
        swap(b[2].first, b[2].second);
        for (int k1 = 0; k1 < 4; ++k1) {
          for (int k2 = 0; k2 < 4; ++k2) {
            for (int k3 = 0; k3 < 8; ++k3) {
              for (int k4 = 0; k4 < 4; ++k4) {
                long long p = calc(b, k1, k2, k3, k4);
                if (p != -1) {
                  ans = min(ans, p);
                }
              }
            }
          }
        }
      }
    }
  } while (next_permutation(o, o + 3));

  printf("%lld\n", ans);
  return 0;
}
